// PTA (12 13) = [3 4] // ready signal and XS2
// PTB (0 1 2 3) = [16 17 19 18] // For address bits
// PTC (0 1 2 3 4 5 6 7) = [15 22 23 9 10 13 11 12] // For digital inputs from NI cards
// PTD (0 1 2 3 4 5 6 7) = [2 14 7 8 6 20 21 5] // For digital output to EEG system

byte inputPins[] = {3, 4, 16, 17, 19, 18, 15, 22, 23, 9, 10, 13, 11, 12};
byte outputPIns[] = {2, 14, 7, 8, 6, 20, 21, 5};

unsigned long sensorVal = 0;
unsigned int onDur = 500;

IntervalTimer myTimerOne;
IntervalTimer myTimerTwo;

void trialSt(void) {
  sensorVal = (GPIOA_PDIR >> 12) & 0xF; // Register A, ready signal and XS2
  if (!(sensorVal & 1) && ((GPIOB_PDIR & 0xF) == 1) && (sensorVal & 2)) { // Received command
    GPIOD_PDOR = 0x80; // XS2
    delayMicroseconds(onDur);
    GPIOD_PDOR = 0x00; // XS2
  }
}

void markerSt(void) {
  if (!(sensorVal & 1) && ((GPIOB_PDIR & 0xF) == 1)) {
    GPIOD_PDOR = (GPIOC_PDIR >> 1) & 0xFF;
    delayMicroseconds(onDur);
    GPIOD_PDOR = 0x00;
  }
}

void setup() {
  for (int pinnum = 0; pinnum < 14; pinnum++) {
    //    pinMode(inputPins[pinnum], INPUT_PULLUP);
    pinMode(inputPins[pinnum], INPUT);
  }
  for (int pinnum = 0; pinnum < 8; pinnum++) {
    pinMode(outputPIns[pinnum], OUTPUT);
  }
  myTimerOne.priority(0);
  myTimerOne.begin(trialSt, 1);
  myTimerOne.priority(0);
  myTimerTwo.priority(1);
  myTimerTwo.begin(markerSt, 1);
  myTimerTwo.priority(1);
}

void loop() {
}

