#define SIMPLEFIFO_LARGE

#include <SimpleFIFO.h>

// PTA (12 13) = [3 4] // ready signal and XS2
// PTB (0 1 2 3) = [16 17 19 18] // For address bits
// PTC (0 1 2 3 4 5 6 7) = [15 22 23 9 10 13 11 12] // For digital inputs from NI cards
// PTD (0 1 2 3 4 5 6 7) = [2 14 7 8 6 20 21 5] // For digital output to EEG system

IntervalTimer myTimerEnque;
IntervalTimer myTimerTrChk;
IntervalTimer myTimerChacOut;
elapsedMillis currTime;

SimpleFIFO <long, 255> sFIFO;

unsigned long quevalue = 0;
byte inputPins[] = {3, 4, 16, 17, 19, 18, 15, 22, 23, 9, 10, 13, 11, 12};
byte outputPIns[] = {2, 14, 7, 8, 6, 20, 21, 5};

unsigned long sensorVal1 = 0;
unsigned long sensorVal2 = 0;
unsigned int onDur = 500;
unsigned long tPeriod = 20000;
unsigned long timeOut = 100;
volatile boolean charOn = false;
unsigned long cValue = 0;
volatile boolean interruptStatus = false;

void characterOut() {
  if (charOn && (currTime > timeOut)) {
    while (sFIFO.count() > 0) {
      GPIOD_PDOR = sFIFO.dequeue();
      delayMicroseconds(onDur);
      GPIOD_PDOR = 0x00;
      delayMicroseconds(onDur);
    }
    sFIFO.flush();
    charOn = false;
  }
}

void trCheck() {
  sensorVal1 = (GPIOA_PDIR >> 12) & 0xF; // Register A, ready signal and XS2
  if (interruptStatus && (sensorVal1 & 2)) { // Received command
    currTime = 0;
    charOn = true;
    //     interruptStatus = false;
  }
}

void enQue() {
  if (interruptStatus && ((GPIOB_PDIR & 0xF) == 7)) { // Received command
    sFIFO.enqueue(GPIOC_PDIR & 0xFF);
    interruptStatus = false;
  }
}

void interruptAction() {
  interruptStatus = true;
}

void setup() {
  for (int pinnum = 0; pinnum < 14; pinnum++) {
    //    pinMode(inputPins[pinnum], INPUT_PULLUP);
    pinMode(inputPins[pinnum], INPUT);
  }
  for (int pinnum = 0; pinnum < 8; pinnum++) {
    pinMode(outputPIns[pinnum], OUTPUT);
  }

  NVIC_SET_PRIORITY(IRQ_PORTA + 16, 1);

  attachInterrupt(3, interruptAction, FALLING);

  myTimerEnque.priority(2);
  myTimerEnque.begin(enQue, 1);
  myTimerEnque.priority(2);

  myTimerTrChk.priority(0);
  myTimerTrChk.begin(trCheck, 1);
  myTimerTrChk.priority(0);

  myTimerChacOut.priority(16);
  myTimerChacOut.begin(characterOut, tPeriod);
  myTimerChacOut.priority(16);
  sFIFO.flush();
}

void loop() {
}

