currDir = cd;
bDir = [currDir '\data\'];

dirList = {'SSK','SMK','SJH','MJS','LYM','KTJ','KSH','KKM','KDH','KCH','JJH','BSW','ABJ','LCM','LJJ'}; 

lstLength = length(dirList);

allChannel = [1:64];

dPad = 3;
bkOpt = 1;

stepSize = 5;
wSize = 20;

bkWin = [-99:-50];
btNum = 500;

evV = 0.5;

dAccuracy = cell(lstLength, 1);

for n = 1:lstLength
	load([bDir dirList{n} '_organizedEEGdata.mat']);
	outMat = prepareEEGfwdModel(outData, [-100 400], wSize, stepSize, dPad, {'Cosine', 15}, bkOpt, bkWin);
	[output] = eegFwdModelLCoutDecodeAccuracy(outMat, dPad, allChannel, btNum, evV, 1);
	dAccuracy{n} = output;
end


time = dAccuracy{1}.time;
dir = dAccuracy{1}.dir;

tLength = length(time);

tWin = [50:25:200];
wSze = [-25 25];

tV = [];
for i = 1:length(tWin)
	tV = [tV;find(time >= tWin(i)+wSze(1) & time <= tWin(i)+wSze(2))];
end

tuningValues =[];

numCond = size(tV, 1);

[tCurve]=fwdModelTuningCurve(dir, -30, 'Cosine', 15);

for n = 1:lstLength
	tunData = dAccuracy{n}.eegPred;
	trNum = size(tunData,3);
	evs = nan(trNum,numCond);
	pfDir = nan(trNum, numCond);
	maxV = nan(trNum, numCond);
	minV = nan(trNum,numCond);
	hwV = nan(trNum,numCond);
	parfor m = 1:trNum
		tunV = [];
		dte = [];
		for o = 1:numCond
			tunV = squeeze(mean(tunData(:, tV(o,:), m), 2));
			dte = dirTuningFEMeeg(dir, tunV, 'wrapnormal');
			evs(m, o) = dte.params.ev;
			pfDir(m,o) = dte.estimates.pfDir;
			maxV(m,o) = dte.estimates.amplitude;
			minV(m,o) = dte.estimates.offset;
			hwV(m,o) = dte.estimates.halfWidth;
		end
	end
	tuningValues(n).ev = evs;
	tuningValues(n).pfDir = pfDir;
	tuningValues(n).amplitude = maxV;
	tuningValues(n).offset = minV;
	tuningValues(n).halfWidth = hwV;
end

save('dAccuracyData.mat', 'dAccuracy');
save('tunValues.mat', 'tuningValues');