function [stimSortedPred, zScoredPred, dirCond, sumStats] = eegFwdModelTemporalGenCondOut_boot(wMat, eegData, cMat, tInfo, dPad, Elc, btNum)
%
% A routine for forward encoding/decoding model analysis
%
% outMat: output of prepareEEGfwdModel.m function
% Elc: electrodes indices
% 
% 03/01/2017 Joonyeol Lee
% joonyeol@skku.edu
%
% 06/09/2018 Revisit the eegFwdModel leave one condition outMat
% reedit the file based on the eegFwdModel_ver1.m function
%
% 07/11/2018 Joonyeol Lee
% Leave-one-condition out and bootstrap analysis - for temporal generalization
%


rng('shuffle', 'twister');

timeTick = tInfo.timeTick;
tDur = length(timeTick);
stimInfo = tInfo.stimInfo;
dirCond = tInfo.cond;

numCond = length(dirCond);

stimSortedPred = cell(numCond, 1);
zScoredPred = cell(numCond,1);

NoT = size(stimInfo,1);

for dCond = 1:numCond
	select = find(stimInfo(:,3) == dirCond(dCond));
	tsData = eegData(:,:,select);

	cMatPred = nan(size(cMat,1), tDur, length(select));

	for i = 1:tDur
		testData = squeeze(tsData(Elc, i, :));
		W = wMat{dCond};
		tmpCov = transpose(W)*W;
		WWinv = pinv(tmpCov);
		for j = 1:length(select)
			B2 = testData(:, j);
			cMatPred(:, i, j) = WWinv*transpose(W)*B2;
		end
	end
	stimSortedPred{dCond} = squeeze(cMatPred);
	
	btCond = nan(length(select), btNum);
	for bt = 1:btNum
		currTr = randperm(NoT);
		btCond(:, bt) = currTr(1:length(select));
	end
	
	stimSortedPred_boot = nan(size(cMat,1), tDur, btNum);

	parfor bt = 1:btNum
		cChoice = btCond(:, bt);
		tsData = eegData(:,:,cChoice);

		cMatPred = nan(size(cMat,1), tDur, length(cChoice));

		for i = 1:tDur
			testData = squeeze(tsData(Elc, i, :));
			W = wMat{dCond};
			tmpCov = transpose(W)*W;
			WWinv = pinv(tmpCov);
			for j = 1:length(cChoice)
				B2 = testData(:, j);
				cMatPred(:, i, j) = WWinv*transpose(W)*B2;
			end
		end
		stimSortedPred_boot(:, :, bt) = squeeze(mean(cMatPred,3));
	end
	tmpV = squeeze(mean(stimSortedPred{dCond}, 3));
	zScoredPred{dCond} = (tmpV - mean(stimSortedPred_boot,3))./std(stimSortedPred_boot, [], 3);
end

switch dPad
case 0
	dirAngles = dirCond;
case 1
	dirAngles = [dirCond(1)-30;dirCond;dirCond(end)+30];
case 2
	dirAngles = [dirCond(1)-2*30;dirCond(1)-1*30;dirCond;dirCond(end)+1*30;dirCond(end)+2*30];
case 3
	dirAngles = [dirCond(1)-3*30;dirCond(1)-2*30;dirCond(1)-1*30;dirCond;dirCond(end)+1*30;dirCond(end)+2*30;;dirCond(end)+3*30];
end

nDirs = transpose([-180:30:150]);
newData = nan(length(nDirs), tDur);
nStimSortedPred = [];
nStimSortedPred_bootZ = [];
for i = 1:numCond
	currDirs = dirAngles - dirCond(i);
	v = mean(stimSortedPred{i}, 3);
	bv = zScoredPred{i};
	oIdx = find(currDirs >= 180);
	currDirs(oIdx) = currDirs(oIdx)-360;
	oIdx = find(currDirs < -180);
	currDirs(oIdx) = currDirs(oIdx)+360;
	nV = newData;
	nBV = newData;
	for j = 1:length(currDirs)
		cIdx = find(nDirs == currDirs(j));
		nV(cIdx,:) = v(j,:);
		nBV(cIdx,:) = bv(j,:);
	end
	nStimSortedPred = cat(3, nStimSortedPred, nV);
	nStimSortedPred_bootZ = cat(3, nStimSortedPred_bootZ, nBV);
end

sumStats.avg = nanmean(nStimSortedPred, 3);;
sumStats.time = timeTick;
sumStats.dir = nDirs;
sumStats.boot = nanmean(nStimSortedPred_bootZ, 3);