function [CValues]=fwdModelTuningCurve(theta, preTheta, type, p)

% CValues=Tuning Curve returns a theoretical tuning curve for the a given
% preferred orientation.
% preTheta - preferred orientation in deg
% p - power of the tuning curve
% type - 1. Cosine, 2. von Mises (Cicular Gaussian)


outTheta = (theta - preTheta).*(pi/180);
switch type
	case 'Cosine'
		CValues = cosTuning(outTheta, p);
		
	case 'vonMises'
		CValues = vonMisesTuning(outTheta, p);
end


function C = cosTuning(outTheta, p)

    C=(0.5 + (0.5 *cos(outTheta))).^p;

function C = vonMisesTuning(outTheta, kap)
    
%	C=(0.0005 + 0.0095 *exp(kap*cos(outTheta))));
	C=((exp(kap*cos(outTheta)))./(2*pi*besseli(0, kap)));